/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.fat;

import jpcsp.HLE.VFS.fat.FatFileInfo;
import jpcsp.util.Utilities;

public class FatUtils {
    public static int getSectorNumber(long position) {
        return (int)(position / 512L);
    }

    public static int getSectorOffset(long position) {
        return (int)(position % 512L);
    }

    public static void storeSectorInt32(byte[] sector, int offset, int value) {
        Utilities.writeUnaligned32(sector, offset, value);
    }

    public static void storeSectorInt8(byte[] sector, int offset, int value) {
        sector[offset] = (byte)value;
    }

    public static void storeSectorInt16(byte[] sector, int offset, int value) {
        Utilities.writeUnaligned16(sector, offset, value);
    }

    public static int readSectorInt32(byte[] sector, int offset) {
        return Utilities.readUnaligned32(sector, offset);
    }

    public static int readSectorInt16(byte[] sector, int offset) {
        return Utilities.readUnaligned16(sector, offset);
    }

    public static int readSectorInt8(byte[] sector, int offset) {
        return Utilities.read8(sector, offset);
    }

    public static String readSectorString(byte[] sector, int offset, int length) {
        String s = "";
        for (int i = length - 1; i >= 0; --i) {
            if (sector[offset + i] == 32) continue;
            s = new String(sector, offset, i + 1);
            break;
        }
        return s;
    }

    public static void storeSectorString(byte[] sector, int offset, String value, int length) {
        int stringLength = Math.min(value.length(), length);
        Utilities.writeStringNZ(sector, offset, stringLength, value);
        for (int i = stringLength; i < length; ++i) {
            sector[offset + i] = 32;
        }
    }

    public static FatFileInfo[] extendArray(FatFileInfo[] array, int extend) {
        if (array == null) {
            return new FatFileInfo[extend];
        }
        FatFileInfo[] newArray = new FatFileInfo[array.length + extend];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }
}

